document.addEventListener('DOMContentLoaded', () => {
    const voiceButton = document.getElementById('voice-search');
    const micIcon = voiceButton.querySelector('i');
    const searchInput = document.getElementById('search-input');
    const form = document.querySelector('.product-search');
    const srStatus = document.getElementById('voice-status');
    const visualFeedback = document.getElementById('voice-feedback');

    const SpeechRecognition =
        window.SpeechRecognition || window.webkitSpeechRecognition;

    if (!SpeechRecognition) {
        visualFeedback.textContent = "Voice search not supported in this browser.";
        voiceButton.disabled = true;
        return;
    }

    const recognition = new SpeechRecognition();
    recognition.lang = 'en-AU';
    recognition.interimResults = false;

    voiceButton.addEventListener('click', () => {
        voiceButton.classList.remove('processing', 'error');
        voiceButton.classList.add('listening');
        voiceButton.setAttribute('aria-pressed', 'true');

        visualFeedback.textContent = "Listening… speak now";
        srStatus.textContent = "Listening for your search term";

        recognition.start();
    });

    recognition.addEventListener('result', (event) => {
        const transcript = event.results[0][0].transcript;

        voiceButton.classList.remove('listening');
        voiceButton.classList.add('processing');

        visualFeedback.textContent = `Heard: “${transcript}”`;
        srStatus.textContent = `Heard ${transcript}`;

        searchInput.value = transcript;

        setTimeout(() => {
            visualFeedback.textContent = "Searching…";
            form.submit();
        }, 700);
    });

    recognition.addEventListener('error', () => {
        voiceButton.classList.remove('listening');
        voiceButton.classList.add('error');

        visualFeedback.textContent = "Sorry, I didn’t catch that.";
        srStatus.textContent = "Voice recognition error";

        voiceButton.setAttribute('aria-pressed', 'false');
    });

    recognition.addEventListener('end', () => {
        voiceButton.classList.remove('listening', 'processing');
        voiceButton.setAttribute('aria-pressed', 'false');
    });
});
