<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Your one-stop shop for athletic clothing, sports equipment, and accessories.">
    <title>Sports Warehouse</title>
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>

<a href="#main-content" class="skiptocontent">SKIP TO MAIN CONTENT</a>

<header>
    <div class="logo">
        <img src="images/sports-warehouse-logo-600.png" alt="Sports Warehouse">
    </div>

    <!-- CHECKBOX HAMBURGER -->
    <input type="checkbox" id="menu-toggle" class="menu-toggle">
    <label for="menu-toggle" class="hamburger">&#9776;</label>

    <nav class="nav-menu">
        <ul>
            <li><a href="index.php">Home</a></li>
            <li><a href="catalog.php">Catalog</a></li>
            <li><a href="cart.php">Cart</a></li>

            <?php if (isset($_SESSION['user_id'])): ?>
                <li><span>Welcome, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</span></li>
                <li><a href="logout.php">Logout</a></li>
            <?php else: ?>
                <li><a href="login.php">Login</a></li>
                <li><a href="register.php">Register</a></li>
            <?php endif; ?>

            <li><a href="cms.php">CMS</a></li>
            <li><a href="contact.php">Contact</a></li>
        </ul>
    </nav>
</header>
